
'use client'

import { motion } from 'framer-motion'
import { Star, Quote } from 'lucide-react'
import Image from 'next/image'

export default function TestimonialsSection() {
  const testimonials = [
    {
      name: 'أحمد محمد',
      role: 'متداول محترف',
      image: 'https://i.pinimg.com/originals/8b/68/9e/8b689e09b7e45051e58f43afc7fa4771.jpg',
      rating: 5,
      text: 'مؤشرات NiceProTrader غيرت طريقة تداولي بالكامل. الدقة في التحليل والإشارات الواضحة ساعدتني على تحقيق أرباح ثابتة.'
    },
    {
      name: 'سارة أحمد',
      role: 'مستثمرة',
      image: 'https://i.pinimg.com/originals/77/71/68/7771683223d86b237a3304d6f32828b9.jpg',
      rating: 5,
      text: 'أفضل مؤشرات استخدمتها على الإطلاق. الواجهة سهلة الاستخدام والنتائج مذهلة. أنصح بها كل متداول جاد.'
    },
    {
      name: 'محمد علي',
      role: 'محلل مالي',
      image: 'https://i.pinimg.com/originals/b1/f4/81/b1f4814bd3205ede51d6873ee6ca4cbc.jpg',
      rating: 5,
      text: 'الذكاء الاصطناعي المدمج في المؤشرات يوفر تحليلات عميقة لم أجدها في أي مكان آخر. استثمار يستحق كل قرش.'
    },
    {
      name: 'ليلى حسن',
      role: 'متداولة مبتدئة',
      image: 'https://i.ytimg.com/vi/I4yiHiM8OgI/maxresdefault.jpg',
      rating: 5,
      text: 'كمتداولة مبتدئة، ساعدتني هذه المؤشرات على فهم السوق بسرعة وتجنب الخسائر الكبيرة. الدعم الفني ممتاز أيضاً.'
    }
  ]

  return (
    <section className="section-padding bg-black">
      <div className="container-custom">
        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            ماذا يقول{' '}
            <span className="text-gradient">عملاؤنا؟</span>
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            آراء حقيقية من متداولين يستخدمون مؤشراتنا يومياً
          </p>
        </motion.div>

        <div className="grid md:grid-cols-2 gap-8">
          {testimonials.map((testimonial, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.1 }}
              viewport={{ once: true }}
              className="card-hover rounded-2xl p-8 relative"
            >
              <div className="absolute top-6 left-6">
                <Quote className="w-8 h-8 text-green-500/30" />
              </div>
              
              <div className="flex items-center gap-4 mb-6">
                <div className="relative w-16 h-16 rounded-full overflow-hidden">
                  <Image
                    src={testimonial.image}
                    alt={testimonial.name}
                    fill
                    className="object-cover"
                  />
                </div>
                <div>
                  <h4 className="font-bold text-lg">{testimonial.name}</h4>
                  <p className="text-gray-400">{testimonial.role}</p>
                </div>
              </div>

              <div className="flex gap-1 mb-4">
                {[...Array(testimonial.rating)].map((_, i) => (
                  <Star key={i} className="w-5 h-5 text-yellow-500 fill-current" />
                ))}
              </div>

              <p className="text-gray-300 leading-relaxed">
                "{testimonial.text}"
              </p>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.6 }}
          viewport={{ once: true }}
          className="text-center mt-16"
        >
          <div className="bg-gradient-to-r from-green-500/10 to-blue-500/10 rounded-2xl p-8 border border-green-500/20">
            <div className="flex justify-center items-center gap-8 mb-6">
              <div className="text-center">
                <div className="text-3xl font-bold text-green-500">4.9/5</div>
                <div className="text-gray-400">تقييم العملاء</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-blue-500">50K+</div>
                <div className="text-gray-400">عميل راضي</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-green-500">95%</div>
                <div className="text-gray-400">معدل التجديد</div>
              </div>
            </div>
            <button className="btn-primary px-8 py-4 rounded-lg font-semibold text-lg">
              انضم إلى عملائنا السعداء
            </button>
          </div>
        </motion.div>
      </div>
    </section>
  )
}
