
'use client'

import { motion } from 'framer-motion'
import { Check, Star, Zap } from 'lucide-react'

export default function PricingSection() {
  const plans = [
    {
      name: 'Pro',
      price: 49,
      yearlyPrice: 35,
      description: 'كل ما تحتاجه للتداول الذكي والفعال',
      popular: false,
      features: [
        'المؤشرات الأساسية الأربعة',
        'الوصول إلى المجتمع',
        'جلسات التداول الأسبوعية',
        'دعم فني أساسي',
        'تحديثات مجانية',
        'دليل المستخدم الشامل'
      ]
    },
    {
      name: 'Plus',
      price: 89,
      yearlyPrice: 59,
      description: 'دفعة إضافية من القوة للمتداولين المحترفين',
      popular: true,
      features: [
        'جميع ميزات خطة Pro',
        'مؤشرات إضافية متقدمة',
        'ميزات حصرية',
        'جميع مؤشرات المؤثرين',
        'إنشاء إشارات مخصصة',
        'دعم فني متقدم',
        'تحليلات مخصصة',
        'أولوية في الدعم'
      ]
    }
  ]

  return (
    <section id="pricing" className="section-padding bg-gradient-to-b from-gray-900 to-black">
      <div className="container-custom">
        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            خطط{' '}
            <span className="text-gradient">الاشتراك</span>
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto mb-8">
            اختر الخطة المناسبة لك وابدأ رحلتك في التداول الاحترافي
          </p>
          
          {/* Discount Badge */}
          <div className="inline-flex items-center gap-2 bg-green-500/20 border border-green-500/30 rounded-full px-4 py-2 mb-8">
            <Zap className="w-4 h-4 text-green-500" />
            <span className="text-green-500 font-semibold">خصم 20% باستخدام كود: NICE20</span>
          </div>
        </motion.div>

        <div className="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
          {plans.map((plan, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.2 }}
              viewport={{ once: true }}
              className={`relative card-hover rounded-2xl p-8 ${
                plan.popular ? 'border-green-500/50 bg-gradient-to-b from-green-500/5 to-blue-500/5' : ''
              }`}
            >
              {plan.popular && (
                <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                  <div className="bg-gradient-to-r from-green-500 to-blue-500 text-white px-6 py-2 rounded-full font-semibold flex items-center gap-2">
                    <Star className="w-4 h-4" />
                    الأكثر شعبية
                  </div>
                </div>
              )}

              <div className="text-center mb-8">
                <h3 className="text-2xl font-bold mb-2">{plan.name}</h3>
                <p className="text-gray-300 mb-6">{plan.description}</p>
                
                <div className="space-y-2">
                  <div className="flex items-baseline justify-center gap-2">
                    <span className="text-4xl font-bold">${plan.yearlyPrice}</span>
                    <span className="text-gray-400">/شهر</span>
                  </div>
                  <div className="text-sm text-gray-400">
                    (يُدفع سنوياً ${plan.yearlyPrice * 12})
                  </div>
                  <div className="text-sm text-gray-500 line-through">
                    الدفع الشهري: ${plan.price}/شهر
                  </div>
                </div>
              </div>

              <ul className="space-y-4 mb-8">
                {plan.features.map((feature, featureIndex) => (
                  <li key={featureIndex} className="flex items-center gap-3">
                    <Check className="w-5 h-5 text-green-500 flex-shrink-0" />
                    <span className="text-gray-300">{feature}</span>
                  </li>
                ))}
              </ul>

              <button className={`w-full py-4 rounded-lg font-semibold text-lg transition-all duration-300 ${
                plan.popular 
                  ? 'btn-primary' 
                  : 'btn-secondary'
              }`}>
                ابدأ الآن
              </button>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.6 }}
          viewport={{ once: true }}
          className="text-center mt-16"
        >
          <div className="bg-gradient-to-r from-green-500/10 to-blue-500/10 rounded-2xl p-8 border border-green-500/20">
            <h3 className="text-2xl font-bold mb-4">ضمان تثبيت السعر مدى الحياة</h3>
            <p className="text-gray-300 max-w-2xl mx-auto">
              سعر اشتراكك يظل ثابتاً مدى الحياة - لن نرفع السعر عليك أبداً، 
              مهما طال اشتراكك معنا
            </p>
          </div>
        </motion.div>
      </div>
    </section>
  )
}
