
'use client'

import { motion } from 'framer-motion'
import { Download, Settings, TrendingUp, CheckCircle } from 'lucide-react'

export default function HowItWorksSection() {
  const steps = [
    {
      icon: Download,
      title: 'تحميل وتثبيت',
      description: 'حمل المؤشرات بكل سهولة وثبتها على منصة التداول المفضلة لديك',
      step: '01'
    },
    {
      icon: Settings,
      title: 'إعداد وتخصيص',
      description: 'اضبط الإعدادات حسب أسلوب تداولك والأسواق التي تتداول فيها',
      step: '02'
    },
    {
      icon: TrendingUp,
      title: 'ابدأ التداول',
      description: 'استخدم الإشارات والتحليلات لاتخاذ قرارات تداول مدروسة',
      step: '03'
    },
    {
      icon: CheckCircle,
      title: 'حقق الأرباح',
      description: 'استفد من التحليلات المتقدمة لتحسين نتائج التداول وزيادة الأرباح',
      step: '04'
    }
  ]

  return (
    <section id="how-it-works" className="section-padding bg-black">
      <div className="container-custom">
        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            كيف يعمل{' '}
            <span className="text-gradient">النظام؟</span>
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            خطوات بسيطة للبدء في التداول الاحترافي
          </p>
        </motion.div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {steps.map((step, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.2 }}
              viewport={{ once: true }}
              className="relative text-center group"
            >
              {/* Connection Line */}
              {index < steps.length - 1 && (
                <div className="hidden lg:block absolute top-16 left-full w-full h-0.5 bg-gradient-to-r from-green-500 to-blue-500 z-0"></div>
              )}
              
              <div className="relative z-10">
                <div className="mb-6">
                  <div className="relative mx-auto w-32 h-32 rounded-full bg-gradient-to-br from-green-500/20 to-blue-500/20 border border-green-500/30 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                    <step.icon className="w-12 h-12 text-green-500" />
                    <div className="absolute -top-4 -right-4 w-12 h-12 rounded-full bg-gradient-to-br from-green-500 to-blue-500 flex items-center justify-center text-black font-bold text-lg">
                      {step.step}
                    </div>
                  </div>
                </div>
                
                <h3 className="text-xl font-bold mb-4">{step.title}</h3>
                <p className="text-gray-300 leading-relaxed">
                  {step.description}
                </p>
              </div>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.8 }}
          viewport={{ once: true }}
          className="text-center mt-16"
        >
          <div className="bg-gradient-to-r from-green-500/10 to-blue-500/10 rounded-2xl p-8 border border-green-500/20">
            <h3 className="text-2xl font-bold mb-4">جاهز للبدء؟</h3>
            <p className="text-gray-300 mb-6">
              انضم إلى آلاف المتداولين الذين يستخدمون مؤشراتنا يومياً
            </p>
            <button className="btn-primary px-8 py-4 rounded-lg font-semibold text-lg">
              ابدأ التداول الآن
            </button>
          </div>
        </motion.div>
      </div>
    </section>
  )
}
