
'use client'

import { motion } from 'framer-motion'
import { ArrowRight, Play, TrendingUp, BarChart3, LineChart } from 'lucide-react'
import Image from 'next/image'

export default function HeroSection() {
  return (
    <section id="home" className="hero-gradient min-h-screen flex items-center pt-16">
      <div className="container-custom">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <motion.div
            initial={{ opacity: 0, x: -50 }}
            animate={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8 }}
            className="space-y-8"
          >
            <div className="space-y-4">
              <h1 className="text-5xl lg:text-7xl font-bold leading-tight">
                أفضل{' '}
                <span className="text-gradient">مؤشرات التداول</span>{' '}
                في فئتها
              </h1>
              <p className="text-xl text-gray-300 leading-relaxed">
                طورت بواسطة خبراء تداول عالميين ومطورين من الطراز الرفيع. 
                احصل على ميزة تنافسية في الأسواق المالية.
              </p>
            </div>

            <div className="flex flex-col sm:flex-row gap-4">
              <button className="btn-primary px-8 py-4 rounded-lg font-semibold text-lg flex items-center justify-center gap-3 group">
                جرب بدون مخاطر لمدة 7 أيام
                <ArrowRight className="w-5 h-5 group-hover:translate-x-1 transition-transform" />
              </button>
              <button className="btn-secondary px-8 py-4 rounded-lg font-semibold text-lg flex items-center justify-center gap-3">
                <Play className="w-5 h-5" />
                شاهد العرض التوضيحي
              </button>
            </div>

            <div className="flex items-center gap-8 pt-8">
              <div className="text-center">
                <div className="text-3xl font-bold text-green-500">50K+</div>
                <div className="text-gray-400">متداول نشط</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-blue-500">95%</div>
                <div className="text-gray-400">معدل الرضا</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold text-green-500">24/7</div>
                <div className="text-gray-400">دعم فني</div>
              </div>
            </div>
          </motion.div>

          <motion.div
            initial={{ opacity: 0, x: 50 }}
            animate={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, delay: 0.2 }}
            className="relative"
          >
            <div className="relative aspect-square bg-gradient-to-br from-green-500/20 to-blue-500/20 rounded-3xl p-8">
              <div className="absolute inset-0 bg-gradient-to-br from-green-500/10 to-blue-500/10 rounded-3xl backdrop-blur-sm"></div>
              
              <div className="relative aspect-video bg-black rounded-2xl overflow-hidden">
                <Image
                  src="https://i.ytimg.com/vi/u6_NsRhGMgM/maxresdefault.jpg"
                  alt="لوحة تحكم التداول الاحترافية"
                  fill
                  className="object-cover"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
              </div>

              {/* Floating Elements */}
              <motion.div
                animate={{ y: [-10, 10, -10] }}
                transition={{ duration: 3, repeat: Infinity }}
                className="absolute top-4 left-4 bg-green-500/20 backdrop-blur-md rounded-lg p-3 border border-green-500/30"
              >
                <TrendingUp className="w-6 h-6 text-green-500" />
                <div className="text-sm font-semibold mt-1">+15.3%</div>
              </motion.div>

              <motion.div
                animate={{ y: [10, -10, 10] }}
                transition={{ duration: 3, repeat: Infinity, delay: 1 }}
                className="absolute top-16 right-4 bg-blue-500/20 backdrop-blur-md rounded-lg p-3 border border-blue-500/30"
              >
                <BarChart3 className="w-6 h-6 text-blue-500" />
                <div className="text-sm font-semibold mt-1">اتجاه صاعد</div>
              </motion.div>

              <motion.div
                animate={{ y: [-5, 15, -5] }}
                transition={{ duration: 3, repeat: Infinity, delay: 2 }}
                className="absolute bottom-4 left-8 bg-yellow-500/20 backdrop-blur-md rounded-lg p-3 border border-yellow-500/30"
              >
                <LineChart className="w-6 h-6 text-yellow-500" />
                <div className="text-sm font-semibold mt-1">إشارة شراء</div>
              </motion.div>
            </div>
          </motion.div>
        </div>
      </div>
    </section>
  )
}
