
'use client'

import { motion } from 'framer-motion'
import { TrendingUp, Mail, MessageCircle, Shield, Clock } from 'lucide-react'

export default function Footer() {
  const footerLinks = [
    {
      title: 'المنتج',
      links: [
        { name: 'المؤشرات', href: '#features' },
        { name: 'الأسعار', href: '#pricing' },
        { name: 'العروض التوضيحية', href: '#' }
      ]
    },
    {
      title: 'الدعم',
      links: [
        { name: 'مركز المساعدة', href: '#faq' },
        { name: 'تواصل معنا', href: '#contact' },
        { name: 'الدعم الفني', href: '#' }
      ]
    },
    {
      title: 'الشركة',
      links: [
        { name: 'من نحن', href: '#' },
        { name: 'شروط الخدمة', href: '#' },
        { name: 'سياسة الخصوصية', href: '#' }
      ]
    }
  ]

  const securityFeatures = [
    {
      icon: Shield,
      text: 'حماية SSL 256-bit'
    },
    {
      icon: Clock,
      text: 'دعم 24/7'
    },
    {
      icon: MessageCircle,
      text: 'استجابة سريعة'
    }
  ]

  return (
    <footer className="bg-gradient-to-t from-gray-900 to-black border-t border-gray-800">
      <div className="container-custom">
        {/* Main Footer Content */}
        <div className="py-16">
          <div className="grid lg:grid-cols-4 md:grid-cols-2 gap-8">
            {/* Brand Section */}
            <motion.div
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6 }}
              viewport={{ once: true }}
              className="lg:col-span-1"
            >
              <div className="flex items-center space-x-3 space-x-reverse mb-6">
                <TrendingUp className="h-8 w-8 text-green-500" />
                <span className="text-2xl font-bold text-gradient">NiceProTrader</span>
              </div>
              <p className="text-gray-300 leading-relaxed mb-6">
                أفضل مؤشرات التداول الاحترافية لمساعدتك على تحقيق النجاح في الأسواق المالية.
              </p>
              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <Mail className="w-5 h-5 text-green-500" />
                  <a href="mailto:support@nniceprotrader.com" className="text-gray-300 hover:text-white transition-colors">
                    support@nniceprotrader.com
                  </a>
                </div>
              </div>
            </motion.div>

            {/* Footer Links */}
            {footerLinks.map((section, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 50 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6, delay: index * 0.1 }}
                viewport={{ once: true }}
              >
                <h3 className="text-lg font-bold mb-6">{section.title}</h3>
                <ul className="space-y-3">
                  {section.links.map((link, linkIndex) => (
                    <li key={linkIndex}>
                      <a
                        href={link.href}
                        className="text-gray-300 hover:text-white transition-colors duration-300"
                      >
                        {link.name}
                      </a>
                    </li>
                  ))}
                </ul>
              </motion.div>
            ))}
          </div>
        </div>

        {/* Security Features */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="py-8 border-t border-gray-800"
        >
          <div className="flex flex-wrap items-center justify-center gap-8">
            {securityFeatures.map((feature, index) => (
              <div key={index} className="flex items-center gap-2 text-gray-400">
                <feature.icon className="w-4 h-4" />
                <span className="text-sm">{feature.text}</span>
              </div>
            ))}
          </div>
        </motion.div>

        {/* Bottom Footer */}
        <motion.div
          initial={{ opacity: 0 }}
          whileInView={{ opacity: 1 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="py-6 border-t border-gray-800 text-center"
        >
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <p className="text-gray-400 text-sm">
              © 2025 NiceProTrader. جميع الحقوق محفوظة.
            </p>
            <div className="text-gray-400 text-sm">
              <span className="text-yellow-500">⚠️</span> إخلاء مسؤولية: المؤشرات مخصصة لأغراض تعليمية وتحليلية ولا تشكل نصيحة مالية.
            </div>
          </div>
        </motion.div>
      </div>
    </footer>
  )
}
