
'use client'

import { motion } from 'framer-motion'
import { TrendingUp, Target, Zap, Shield, BarChart3, LineChart, Activity, Brain } from 'lucide-react'
import Image from 'next/image'

export default function FeaturesSection() {
  const features = [
    {
      icon: TrendingUp,
      title: 'مؤشرات الأموال الذكية',
      description: 'اكتشف تحركات المؤسسات الكبرى والمستثمرين المحترفين في الوقت الفعلي',
      image: 'https://i.ytimg.com/vi/-AlThXPfawE/maxresdefault.jpg'
    },
    {
      icon: Target,
      title: 'تحديد الفرص بدقة',
      description: 'خوارزميات متقدمة تحدد نقاط الدخول والخروج المثلى بدقة عالية',
      image: 'https://i.pinimg.com/736x/43/1a/b0/431ab09748ab6b29c2fe919d027bda4b.jpg'
    },
    {
      icon: Zap,
      title: 'إشارات فورية',
      description: 'احصل على إشارات التداول فور حدوثها مع تنبيهات مخصصة',
      image: 'https://i.ytimg.com/vi/l7pcibUxEyo/maxresdefault.jpg'
    },
    {
      icon: Shield,
      title: 'إدارة المخاطر',
      description: 'أدوات متقدمة لإدارة المخاطر وحماية رأس المال',
      image: 'https://i.pinimg.com/originals/ff/53/b9/ff53b93551031db92ec2f761986925da.png'
    },
    {
      icon: BarChart3,
      title: 'تحليل الحجم المتقدم',
      description: 'تحليل عميق للحجم ومناطق السيولة لفهم قوة الاتجاهات',
      image: 'https://i.ytimg.com/vi/sGghBy1lGjg/maxresdefault.jpg'
    },
    {
      icon: Brain,
      title: 'ذكاء اصطناعي',
      description: 'تقنيات الذكاء الاصطناعي لتحليل الأنماط وتوقع حركة الأسعار',
      image: 'https://www.codemotion.com/magazine/wp-content/uploads/2022/06/Big-Data1.jpg'
    }
  ]

  return (
    <section id="features" className="section-padding bg-gradient-to-b from-black to-gray-900">
      <div className="container-custom">
        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            مجموعة الأدوات{' '}
            <span className="text-gradient">المتكاملة</span>
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            كل ما تحتاجه للتداول الذكي والفعال في مكان واحد
          </p>
        </motion.div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {features.map((feature, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.1 }}
              viewport={{ once: true }}
              className="card-hover rounded-2xl p-6 group"
            >
              <div className="aspect-video mb-6 rounded-xl overflow-hidden bg-gradient-to-br from-green-500/10 to-blue-500/10">
                <Image
                  src={feature.image}
                  alt={feature.title}
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              
              <div className="flex items-center gap-4 mb-4">
                <div className="p-3 rounded-xl bg-gradient-to-br from-green-500/20 to-blue-500/20 border border-green-500/30">
                  <feature.icon className="w-6 h-6 text-green-500" />
                </div>
                <h3 className="text-xl font-bold">{feature.title}</h3>
              </div>
              
              <p className="text-gray-300 leading-relaxed">
                {feature.description}
              </p>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.8 }}
          viewport={{ once: true }}
          className="text-center mt-16"
        >
          <button className="btn-primary px-8 py-4 rounded-lg font-semibold text-lg">
            استكشف جميع الميزات
          </button>
        </motion.div>
      </div>
    </section>
  )
}
