
'use client'

import { useState } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { Plus, Minus } from 'lucide-react'

export default function FaqSection() {
  const [openIndex, setOpenIndex] = useState<number | null>(0)

  const faqs = [
    {
      question: 'ما هي المنصات التي تدعمها مؤشراتكم؟',
      answer: 'مؤشراتنا تعمل على جميع المنصات الرئيسية مثل MetaTrader 4, MetaTrader 5, TradingView, و cTrader. نقدم أيضاً دعماً لمنصات أخرى حسب الطلب.'
    },
    {
      question: 'هل يوجد فترة تجريبية مجانية؟',
      answer: 'نعم، نقدم فترة تجريبية مجانية لمدة 7 أيام لجميع المؤشرات الجديدة. يمكنك اختبار جميع الميزات والتأكد من ملاءمتها لأسلوب تداولك قبل الاشتراك.'
    },
    {
      question: 'كيف يتم تسليم المؤشرات؟',
      answer: 'بعد الاشتراك مباشرة، ستحصل على رابط تحميل المؤشرات مع دليل التثبيت المفصل. كما نقدم دعماً فنياً مجانياً لمساعدتك في عملية التثبيت.'
    },
    {
      question: 'هل المؤشرات مناسبة للمبتدئين؟',
      answer: 'نعم تماماً! مؤشراتنا مصممة لتكون سهلة الاستخدام للمبتدئين مع توفير ميزات متقدمة للمحترفين. نقدم أيضاً دورات تدريبية ودعماً شخصياً.'
    },
    {
      question: 'ما هي سياسة الاسترداد؟',
      answer: 'نقدم ضماناً لاسترداد المال لمدة 30 يوماً. إذا لم تكن راضياً عن أداء المؤشرات لأي سبب، يمكنك طلب استرداد كامل خلال هذه الفترة.'
    },
    {
      question: 'هل تتضمن الخطة الدعم الفني؟',
      answer: 'نعم، جميع خططنا تتضمن دعماً فنياً شاملاً. فريقنا متاح على مدار الساعة لمساعدتك في أي استفسارات أو مشاكل تقنية قد تواجهها.'
    },
    {
      question: 'كم مرة يتم تحديث المؤشرات؟',
      answer: 'نقوم بتحديث مؤشراتنا بانتظام لضمان أفضل أداء. التحديثات الأمنية والإصلاحات تتم فورياً، بينما الميزات الجديدة تُضاف شهرياً.'
    },
    {
      question: 'هل يمكنني استخدام المؤشرات على حسابات متعددة؟',
      answer: 'نعم، اشتراك واحد يمنحك الحق في استخدام المؤشرات على حتى 3 حسابات تداول مختلفة. للمزيد من الحسابات، يمكنك ترقية اشتراكك.'
    }
  ]

  return (
    <section className="section-padding bg-gradient-to-b from-black to-gray-900">
      <div className="container-custom">
        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            الأسئلة{' '}
            <span className="text-gradient">الشائعة</span>
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            إجابات شاملة على الأسئلة الأكثر شيوعاً
          </p>
        </motion.div>

        <div className="max-w-4xl mx-auto">
          {faqs.map((faq, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 50 }}
              whileInView={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: index * 0.1 }}
              viewport={{ once: true }}
              className="mb-4"
            >
              <div className="card-hover rounded-xl overflow-hidden">
                <button
                  onClick={() => setOpenIndex(openIndex === index ? null : index)}
                  className="w-full p-6 text-right flex items-center justify-between hover:bg-gray-800/50 transition-colors duration-300"
                >
                  <span className="text-lg font-semibold flex-1">{faq.question}</span>
                  <div className="mr-4">
                    {openIndex === index ? (
                      <Minus className="w-5 h-5 text-green-500" />
                    ) : (
                      <Plus className="w-5 h-5 text-green-500" />
                    )}
                  </div>
                </button>
                
                <AnimatePresence>
                  {openIndex === index && (
                    <motion.div
                      initial={{ height: 0, opacity: 0 }}
                      animate={{ height: 'auto', opacity: 1 }}
                      exit={{ height: 0, opacity: 0 }}
                      transition={{ duration: 0.3 }}
                      className="overflow-hidden"
                    >
                      <div className="px-6 pb-6 text-gray-300 leading-relaxed">
                        {faq.answer}
                      </div>
                    </motion.div>
                  )}
                </AnimatePresence>
              </div>
            </motion.div>
          ))}
        </div>

        <motion.div
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, delay: 0.8 }}
          viewport={{ once: true }}
          className="text-center mt-16"
        >
          <div className="bg-gradient-to-r from-green-500/10 to-blue-500/10 rounded-2xl p-8 border border-green-500/20">
            <h3 className="text-2xl font-bold mb-4">لم تجد إجابة سؤالك؟</h3>
            <p className="text-gray-300 mb-6">
              فريق الدعم الفني متاح على مدار الساعة لمساعدتك
            </p>
            <button className="btn-primary px-8 py-4 rounded-lg font-semibold text-lg">
              تواصل معنا
            </button>
          </div>
        </motion.div>
      </div>
    </section>
  )
}
