
import type { Metadata } from 'next'
import { Montserrat } from 'next/font/google'
import './globals.css'

const montserrat = Montserrat({ 
  subsets: ['latin'],
  weight: ['300', '400', '500', '600', '700', '800'],
  display: 'swap',
})

export const metadata: Metadata = {
  title: 'NiceProTrader - أفضل مؤشرات التداول الاحترافية',
  description: 'اكتشف مؤشرات التداول المتقدمة من NiceProTrader. أدوات احترافية تساعدك على تحديد الفرص وتحقيق الأرباح في الأسواق المالية.',
  keywords: 'مؤشرات التداول، تداول احترافي، أدوات التحليل الفني، NiceProTrader',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="ar" dir="rtl">
      <body className={`${montserrat.className} bg-black text-white antialiased`}>
        {children}
      </body>
    </html>
  )
}
